<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Hungarian Language Lines
    |--------------------------------------------------------------------------
    */
	'validation' => [
    	'numeric' => 'Csak számokat lehet írni ebbe a mezőbe.',
     	'required' => 'A mező kitöltése kötelező.',
    	'date' => 'Érvényes dátumot adj meg.',
    	'ip' => 'Érvényes IP címet adj meg.',
    	'required_without_all' => 'Legalább az egyik mező kitöltése kötelező.',
    	'regex' => 'A megadott mintázatnak megfelelően add meg az értéket.',
    	'email' => 'Érvényes email címet adj meg.',
    	'email_not_found' => 'Az email cím nem található.',
    	'email_token_found' => 'Egy visszaállító email már kiküldésre került.',
    	'min_8' => 'Minimum 8 karakternek kell lennie.',
    	'string' => 'Csak betűk, számok és egyéb karakterek lehetnek.',
    	'password_confirm' => 'A két jelszómező tartalmának egyeznie kell.',
    	'username_unique' => "Ezt a nevet nem választhatod.",
    	'email_unique' => "Ezt az email címet nem választhatod.",
    ],

	'button' => [
    	'login' => 'Bejelentkezés',
    	'save' => 'Mentés',
    	'send' => 'Küldés',
    	'cancel' => 'Mégse',
    	'back' => 'Vissza',
    	'back_without_save' => 'Vissza (mentés nélkül)',
    	'ok' => 'OK',
    	'close' => 'Bezárás',
    	'search' => 'Keresés',
    	'view' => 'Megtekintés',
    	'view_notification_log' => 'Felügyeleti események',
    	'view_dashboard' => 'Dashboard nézet',
    	'view_stored_scripts' => 'Tárolt szkriptek',
    	'view_details' => 'Részletek',
    	'view_global_settings_event_log' => 'Globális beállítások eseménynapló',
    	'emergency_stop' => 'Vészleállítás',
    	'archive' => 'Archiválás',
    	'delete' => 'Törlés',
    	'new' => 'Új',
    	'new_subnetwork' => 'Új alhálózat',
    	'new_workstation' => 'Új munkaállomás',
    	'new_network_printer' => 'Új hálózati nyomtató',
    	'new_network_device' => 'Új hálózati eszköz',
    	'new_command' => 'Új parancs',
    	'new_article' => 'Új bejegyzés',
    	'new_document' => 'Új dokumentum',
    	'new_notification' => 'Új felügyelet',
    	'new_label' => 'Új címke',
    	'new_intervention' => 'Új beavatkozás',
    	'new_subnet' => 'Új alhálózat',
    	'edit' => 'Szerkesztés',
    	'add' => 'Hozzáadás',
    	'add_new' => 'Új hozzáadása',
    	'run' => 'Futtatás',
    	'create' => 'Létrehozás',
    	'register' => 'Regisztráció',
    	'refresh' => 'Frissítés',
    	'refresh_data' => 'Adatok frissítése',
    	'read_more' => 'Tovább olvasom',
    	'upload' => 'Feltöltés',
    	'download' => 'Letöltés',
    	'collect_data' => 'Adatok gyűjtése',
    	'update_data' => 'Adatok frissítése',
    	'create_filter' => 'Szűrő létrehozása',
		'yes' => 'Igen',
    	'no' => 'Nem',
    	'activate' => 'Aktiválás',
    	'deactivate' => 'Inaktiválás',
    	'back_global_settings' => 'Vissza a Globális Beállításokhoz',
    ],
	
	'nav' => [
    	'dashboard' => 'Dashboard',
    	'workstations' => 'Munkaállomások',
    	'ip_table' => 'IP tábla',
    	'notification_center' => 'Felügyeleti Központ',
    	'network_printers' => 'Hálózati nyomtatók',
    	'network_devices' => 'Hálózati eszközök',
    	'topology' => 'Topológia',
    	'command_center' => 'Parancsközpont',
    	'assets' => 'Eszközkészlet',
    	'articles' => 'TudásBázis',
    	'documents' => 'Dokumentumok',
    	'operating_systems' => 'Operációs rendszerek',
    	'monitors' => 'Monitorok',
    	'local_printers' => 'Helyi nyomtatók',
    	'global_settings' => 'Globális Beállítások',
    	'username' => ':username',
    	'my_settings' => 'Beállításaim',
    	'logout' => 'Kijelentkezés',
    	'about' => 'Névjegy',
    	'help' => 'Súgó',
    	'users' => 'Felhasználók',
    	'downloads' => 'Letöltések',
    	'updates' => 'Frissítések',
    	'api_tokens' => 'API Tokenek',
    
    ],
	
	'layout' => [
		'find_workstation' => 'Munkaállomás keresése',
		'intervention' => 'Beavatkozás rögzítése',
		'what_happened' => 'Mi történt?',
		'event_description' => 'Esemény leírása...',
		'operators' => 'Résztvevők',
		'standby_duty' => 'Készenlét',
		'interval' => 'Időintervallum',
		'start_typing' => 'Kezdj el gépelni...',
    	'save_this_suggestion' => 'Mentés a jövőbeni javaslatokhoz',
    	'delete_this_suggestion' => 'Törlés a javaslatok közül',
    	'env_master_key_warning' => 'Az .env fájlban add meg a MASTER_KEY értékét. (MASTER_KEY=[32 karakter (A-Z,a-z,0-9)].',
    ],

	'dashboard' => [
    	'dashboard' => 'Dashboard',
		'workstations' => 'Munkaállomások',
    	'online' => 'bekapcsolva',
    	'offline' => 'kikapcsolva',
    	'locked' => 'zárolva',
    	'unreachable' => 'nem elérhető',
    	'security_risks' => 'Biztonsági kockázatok',
    	'anydesk_connected' => 'Anydesk',
    	'teamviewer_connected' => 'Teamviewer',
    	'rdp_connected' => 'RDP',
    	'vnc_connected' => 'VNC',
    	'usb_connected' => 'USB eszk.',
    	'ip_conflict' => 'IP ütközés',
		'mac_conflict' => 'MAC ütközés',
		'storages' => 'Tárolók',
    	'invalid_hostnames' => 'Érvénytelen hosztnév',
    	'smarterror' => 'S.M.A.R.T. hiba',
    	'network_printers' => 'Hálózati nyomtatók',
    	'order_printer_supply' => 'Kellékanyag-rendelés',
    	'notifications' => 'Felügyelet',
    	'services' => 'Szolgáltatások',
    	'statistics' => 'Statisztika',
    	'workstations_average_age' => 'Munkaáll. átlag kora',
    	'eventlog' => 'Eseménynapló',
    	'interventions' => 'Beavatkozások',
    	'suggested_interventions' => 'Javasolt beavatkozások',
    	'amount' => 'Mennyiség',
    	'action' => 'Művelet',
    	'monday' => 'Hétfő',
		'tuesday' => 'Kedd',
		'wednesday' => 'Szerda',
		'thursday' => 'Csütörtök',
		'friday' => 'Péntek',
		'saturday' => 'Szombat',
		'sunday' => 'Vasárnap',
    	'add_module' => 'Blokk hozzáadása',
    	'block_type' => 'Blokk típusa',
    	'block_content' => 'Blokk tartalma',
    	'empty' => 'Üres',
    	'links' => 'Hivatkozások',
    	'link_name' => 'Hivatkozás elnevezése',
    	'link_url' => 'Hivatkozás URL',
    	'filter_cpu_score_less' => 'CPU értéke kevesebb, mint :value pont',
    	'filter_cpu_score_more' => 'CPU értéke több, mint :value pont',
    	'filter_boottime_more' => 'Rendszerindulás ideje több, mint :seconds másodperc',
    	'filter_uptime_more' => 'Üzemidő több, mint :days nap',
    	'filter_cpu_age_less' => 'CPU kora kevesebb, mint :age év',
    	'filter_cpu_age_more' => 'CPU kora több. mint :age év',
    	'filter_cpu_age_exactly' => 'CPU kora pontosan :age év',
    	'filter_memory_less' => 'Memória mennyisége kevesebb, mint :memoryGB',
    	'filter_memory_more' => 'Memória mennyisége több, mint :memoryGB',
    	'filter_memory_exactly' => 'Memória mennyisége pontosan :memoryGB',
    	'filter_os_drive_free_space_less_or_equal' => 'Szabad lemezterület a rendszermeghajtón pontosan vagy kevesebb, mint :spaceGB',
    	'filter_brand_contains' => 'Márka, típus tartalmaz ":value" kifejezést',
    	'filter_brand_not_contains' => 'Márk, típus nem tartalmaz ":value" kifejezést',
    	'filter_brand_exactly' => 'Márka, típus pontosan ":value"',
    	'filter_hostname_contains' => 'Hosztnév tartalmaz ":value" kifejezést',
    	'filter_hostname_not_contains' => 'Hosztnév nem tartalmaz ":value" kifejezést',
    	'filter_hostname_exactly' => 'Hosztnév pontosan ":value"',
    	'filter_workgroup_contains' => 'Munkacsoport neve tartalmaz ":value" kifejezést',
    	'filter_workgroup_not_contains' => 'Munkacsoport neve nem tartalmaz ":value" kifejezést',
    	'filter_workgroup_exactly' => 'Munkacsoport neve pontosan ":value"',
    	'filter_osname_contains' => 'Op.rendszer neve tartalmaz ":value" kifejezést',
    	'filter_hw_types' => 'Hardver típusok: :types',
    	'filter_disk_types' => 'Lemez típusok: :types',
    	'filter_serial_missing' => 'Nincs sorozatszáma',
    	'filter_inventory_missing' => 'Nincs leltári száma',
    	'filter_offline_more' => 'Nem jelentkezett több, mint :days napja',
    	'filter_osupdate_outdated' => 'Op.rendszer nem frissült több, mint :months hónapja',
    	'filter_admin_rights' => 'A felhasználók adminisztrátori jogosultságokkal rendelkeznek',
    	'filter_has_any_labels' => 'Rendelkezik valamelyik címkével: :labels',
    	'filter_has_all_labels' => 'Rendelkezik az összes ilyen címkével: :labels',
    	'filter_not_has_any_labels' => 'Nem rendelkezik valamelyik címkével: :labels',
    	'filter_not_has_all_labels' => 'Nem rendelkezik az összes ilyen címkével: :labels',
    	'filter_has_ipv6' => 'IPv6 címmel rendelkezik',
    	'filter_ossupport_ended' => 'Az op.rendszert támogatását a gyártó befejezte',
    	'filter_are_you_sure_delete' => 'Biztos, hogy törölni szeretnéd ezt a szűrőt?',
    	
    
    ],

	'workstations' => [
    	'workstation' => 'Munkaállomás',
		'workstations' => 'Munkaállomások',
		'name' => 'Név',
    	'alias' => 'Megnevezés',
    	'hostname' => 'Hosztnév',
		'workgroup' => 'Munkacsoport',
		'last_online' => 'Utoljára online',
		'os_version' => 'Op.rendszer verzió',
		'last_os_update' => 'Utolsó frissítés',
    	'inventory_id' => 'Leltári azonosító',
    	'manual' => 'Kézi',
    	'registered_manually' => 'Munkaállomás kézzel rögzítve',
    	'data_sheet' => 'Adatlap',
    	'connections' => 'Kapcsolatok',
    	'conn_type' => 'Típus',
    	'conn_value' => 'Érték',
    	'conn_notes' => 'Megjegyzés',
    	'conn_action' => 'Művelet',
    	'phone' => 'Telefon',
    	'email' => 'Email',
    	'location' => 'Helyszín',
    	'connect' => 'Kapcsolódás',
    	'call' => 'Hívás',
    	'send' => 'Küldés',
    	'navigate' => 'Navigálás',
    	'save' => 'Mentés',
    	'cancel' => 'Mégsem',
    	'add_connection' => 'Kapcsolat hozzáadása',
    	'no_information_found' => 'Nincs elérhető kapcsolati adat.',
    	'are_you_sure_delete_connection' => "Biztos, hogy törlöd a kapcsolati adatot?",
    	'events' => 'Események',
    	'interventions' => 'Beavatkozások',
    	'consol' => 'Konzol',
    	'suggestions' => 'Javaslatok',
    	'network' => 'Hálózat',
    	'statistics' => 'Statisztika',
    	'actions' => 'Műveletek',
    	'brand_model' => 'Márka, Model',
    	'serial' => 'Sorozatszám',
    	'motherboard_serial' => 'Alaplap sorozatszám',
    	'registered' => 'Regisztrálva',
    	'memory' => 'Memória',
    	'memory_slots' => 'Memória foglalatok',
    	'memory_max' => 'Max. memória',
    	'memory_modules' => 'Memória modulok',
    	'other' => 'Egyéb',
    	'monitors' => 'Monitorok',
    	'disks' => 'Lemezek',
    	'labels' => 'Címkék',
    	'local_user_accounts' => 'Helyi felhasználói fiókok',
    	'administrator' => 'Adminisztrátor',
    	'processor' => 'Processzor',
    	'processor_released' => 'Processzor megjelenése',
    	'yyyymmdd' => 'ÉÉÉÉ-HH-NN',
    	'operating_system' => 'Operációs rendszer',
    	'hyberboot_active' => 'Gyors rendszerindítás aktív!',
    	'os_activated' => 'Op.rendszer aktiválva.',
    	'os_not_activated' => 'Op.rendszer nincs aktiválva.',
    	'last_os_update_search' => 'Frissítés keresve',
    	'last_boot_time' => 'Utolsó teljes rendszerindítás',
    	'boot_time' => 'Boot-idő',
    	'service_started' => 'Szolg. indulása',
    	'os_partition_size' => 'OS partíció mérete',
    	'os_partition_free_space' => 'Szabad terület',
    	'ip_addresses' => 'IP címek',
    	'dns_addresses' => 'DNS címek',
    	'default_mac' => 'Alapértelmezett MAC',
    	'manufacturer_code' => 'Gyártó kódja',
    	'manufacture_year' => 'Gyártási év',
    	'printers' => 'Nyomtatók',
    	'event' => 'Esemény',
    	'event_time' => 'Esemény ideje',
    	'event_description' => 'Esemény leírása',
    	'intervention_time' => 'Beavatkozás ideje',
    	'intervention_description' => 'Beavatkozás leírása',
    	'endpoint_network_connection' => 'Közvetlen hálózati kapcsolat',
    	'network_data' => 'Hálózati adatok',
    	'turn_on_off_computer' => 'Számítógép be/kikapcsolása',
    	'restart_computer' => 'Számítógép újraindítása',
    	'restart_spooler' => 'Nyomtatási spooler újraindítása',
    	'clear_and_restart_spooler' => 'Nyomtatási spooler takarítása és újraindítása',
    	'console_fun' => 'Kezdjük a mókát!',
    	'archive_in_progress' => 'Archiválás folyamatban...',
    	'label_text' => 'Címke szövege',
    	'save_script_to_storage' => 'Szkript mentése tárolóba',
    	'script_storage' => 'Szkript-tár',
    	'script_name' => 'Szkript neve',
    	'script' => 'Szkript',
    	'general' => 'Alapadatok',
    	'are_you_sure_run' => 'Biztos, hogy futtatni akarod ezt a szkriptet?',
    	'are_you_sure_delete_ip' => 'Biztos, hogy törölni akarod ezt az IP címet az adatbázisból?',
    	'type' => 'Eszköz típusa',
    	'desktop' => 'Desktop',
    	'laptop' => 'Laptop',
    	'server' => 'Szerver',
    	'identification_details' => 'Azonosítási adatok',
    	'product_serial' => 'Termék sorozatszáma',
    	'product_serial_help' => 'A BIOS-ban található sorozatszám',
	   	'motherboard_serial_help' => 'Az alaplap sorozatszáma',
    	'first_mac_address' => 'Elsődleges MAC cím',
    	'first_mac_address_help' => 'Az alaplap elsődleges hálózati csatolójának MAC címe',
    	'identification_chance' => 'Azonosíthatóság',
    	'start_typing' => 'Kezdj el gépelni...',
    	'technical_details' => 'Technikai adatok',
    	'network_details' => 'Hálózati adatok',
    	'ip_address' => 'IP cím',
    	'dns_address' => 'DNS cím',
    	'disk' => 'Lemez',
    	'disk_type' => 'Típus',
    	'disk_capacity' => 'Kapacitás',
    	'add_disk' => 'Lemez hozzáadása',
    	'monitor' => 'Monitor',
    	'add_monitor' => 'Monitor hozzáadása',
    	'create_filter' => 'Szűrő létrehozása',
    	'filter_name' => 'Szűrő elnevezése',
		'filter_short_description' => 'Rövid megjegyzés',
		'filter_brand_model' => 'Márka, model',
    	'filter_contains' => 'TARTALMAZZA',
    	'filter_not_contains' => 'NE TARTALMAZZA',
    	'filter_exactly' => 'PONTOSAN',
    	'filter_hostname' => 'Hosztnév',
    	'filter_workgroup' => 'Munkacsoport neve',
    	'filter_cpu_score' => 'CPU pontérték',
    	'filter_more_than' => 'TÖBB, MINT',
    	'filter_less_than' => 'KEVESEBB, MINT',
    	'filter_less_or_equal' => 'PONTOSAN VAGY KEVESEBB, MINT',
    	'filter_cpu_age' => 'CPU kora',
    	'filter_years' => 'év',
    	'filter_memory' => 'Memória mennyisége',
    	'filter_os_drive_free_space' => 'Szabad hely a rendszermeghajtón',
    	'filter_os_name' => 'Op.rendszer neve tartalmazza',
    	'filter_os_update' => 'Op.rendszer frissítve, több mint',
    	'filter_months' => 'hónap',
    	'filter_disk' => 'Adattároló típusa (VAGY kapcsolat)',
    	'filter_unspecified' => 'Ismeretlen',
    	'filter_hw_type' => 'Hardware típusa (VAGY kapcsolat)',
    	'filter_desktop' => 'Desktop',
    	'filter_laptop' => 'Laptop',
    	'filter_server' => 'Szerver',
    	'filter_labels' => 'a következő címkéknek',
    	'filter_any_of_them' => 'BÁRMELYIKÉT (VAGY)',
    	'filter_all_of_them' => 'MINDEGYIKÉT (ÉS)',
    	'filter_has_ipv6' => 'IPv6 címmel rendelkezik.',
    	'filter_serial_missing' => 'Nincs sorozatszáma.',
    	'filter_inventory_missing' => 'Nincs leltári száma.',
    	'filter_has_admin_account' => 'A felhasználók adminisztrátori joggal rendelkeznek. (Kivéve a Globális Beállításokban meghatározott listában szereplő nevek)',
    	'filter_support_ended' => 'Az operációs rendszer támogatását a gyártó befejezte.',
    	'filter_offline_since' => 'Nem jelentkezett több, mint ',
    	'filter_days' => 'nap',
    	'filter_boottime_more_than' => 'Bekapcsolási idő több, mint',
    	'filter_uptime_more_than' => 'Üzemidő több, mint',
    	'filter_seconds' => 'másodperc',
    	'filter_uptime' => 'Üzemidő',
    	'filter_offline' => 'Nem jelentkezett',
    	'filter_points' => 'pont',
    	'printer_statistics' => 'Nyomtatások',
    	'monthly_prints' => 'Nyomtatások száma (30 nap)',
    	'monthly_pages' => 'Nyomtatott oldalak száma (30 nap)',
    	'prints' => 'nyomtatás',
    	'pages' => 'oldal',
    ],

	
	'subnet' => [
    	'ip_table' => 'IP Tábla',
    	'no_subnet_found' => 'Nem található alhálózat.',
    	'ip_address' => 'IP cím',
    	'device' => 'Eszköz',
    	'parameters' => 'Alhálózat adatai',
    	'alias' => 'Elnevezés',
    	'ip_mask' => 'Azonosító IP/Decimális maszk',
    	'gateway' => 'Átjáró',
    	'short_description' => 'Rövid leírás',
    
    ],

	'notification_center' => [
    	'notification_center' => 'Felügyeleti Központ',
    	'eventlog' => 'Felügyeleti eseménynapló',
    	'dashboard_view' => 'Dashboard nézet',
    	'status' => 'Állapot',
    	'alias' => 'Elnevezés',
    	'name' => 'Változónév',
    	'name_helper' => 'Külső eszköz vagy rendszer által beküldött, egyedi változónév. (a-z, 0-9, -) 2-100 karakter',
    	'name_restriction' => 'Tudom, mit csinálok és meg akarom változtatni.',
    	'type' => 'Típus',
    	'parameters' => 'Paraméterek',
    	'description' => 'Leírás',
    	'value' => 'Érték',
    	'active' => 'Aktív',
    	'alert' => 'Riasztásban',
    	'idle' => 'Nyugalomban',
    	'socket_polling' => 'Socket Polling',
    	'socket_polling_description' => 'A cél a megadott IP portjának sikeres elérése. Egyébként riasztást vált ki.',
    	'sensor_value' => 'Szenzorérték',
    	'sensor_value_description' => 'A Paraméterekben megadott aritmetikai kifejezésnek vagy összehasonlításnak igaznak kell lennie. Egyébként riasztást vált ki.',
    	'ping' => 'Ping',
    	'ping_description' => 'A csomagok legalább 50%-nak sikeresen el kell érnie a megadott IP címet.  Egyébként riasztást vált ki.',
    	'mass_heartbeat_loss' => 'Tömeges életjel-kimaradás',
    	'mass_heartbeat_loss_description' => 'Az ugyanabban a 2 percben elérhetetlenné vált munkaállomások száma kevesebb kell legyen, mint a Paraméterekben megadott szám. Egyébként riasztást vált ki.',
    	'biglan_command' => 'BigLan parancs',
    	'biglan_command_description' => 'A Paraméterekben megadott azonosítójú munkaállomáson(wsid) a meghatározott Parancs(command) eredményére futtatott aritmetikai műveletnek vagy összehasonlításnak(expression) igaznak kell lennie. Egyébként riasztást vált ki.',
    	'snmp_description' => 'A Paraméterekben megadott aritmetikai kifejezésnek vagy összehasonlításnak igaznak kell lennie a megadott IP címen lekérdezett OID kód értékére. Egyébként riasztást vált ki.',
    	'http_status_code' => 'HTTP Státusz Kód',
    	'http_status_code_description' => 'A Paraméterekben megadott aritmetikai kifejezésnek vagy összehasonlításnak igaznak kell lennie. Egyébként riasztást vált ki.',
    	'website' => 'Weboldal url',
    	'other' => 'Egyéb',
    	'activated' => 'Élesítve',
    	'disabled' => 'Kikapcsolva',
    	'notification_not_found' => 'Még nincs felügyelet rögzítve.',
    	'notification_details' => 'Felügyelet részletei',
    	'are_you_sure_active' => 'Biztosan megváltozatod a figyelés állapotát?',
    	'ip_address' => 'IP cím',
    	'port' => 'Port',
    	'expression' => 'Kifejezés',
    	'date_and_time' => 'Dátum és idő',
    	'notification_event_not_found' => 'Nincs felügyeleti esemény.',
    	'event' => 'Esemény',
    	'info' => 'Infó',
    	'notification_status_changed' => 'A figyelés állapota megváltozott',
    	'last_value' => 'Utolsó érték',
    	'registered' => 'Regisztrálva',
    	'last_changed' => 'Utolsó módosítás',
    	'events' => 'Események',
    	'status_changed' => 'A(z) :notification állapota :status.',
    	'status_changed_with_value' =>   'A(z) :notification állapota :status. (:value)',
    	'unit' => 'Mértékegység',
    
    ],

	'network_printers' => [
    	'network_printers' => 'Hálózati nyomtatók',
    	'network_printer' => 'Hálózati nyomtató',
    	'new_network_printer' => 'Új hálózati nyomtató',
    	'name' => 'Név',
    	'brand_model' => 'Márka, Típus',
    	'note' => 'Megjegyzés',
    	'serial' => 'Sorozatszám',
    	'ip_address' => 'IP cím',
    	'mac_address' => 'MAC cím',
    	'toner_ink_level' => 'Toner/Tinta szint',
    	'counter' => 'Számláló',
    	'helper' => '2x kattintás a cellára a szerkesztéshez, Shift+Enter a mentéshez, Escape a kilépéshez',
    	'incompatible_toner_ink' => 'Inkompatibilis toner/tinta',
    	'network_printer_not_found' => 'Nincs hálózati nyomtató rögzítve.',
    	'data_sheet' => 'Adatlap',
    	'events' => 'Események',
    	'statistics' => 'Statisztikák',
    	'black_toner_ink_level' => 'Fekete toner/tinta',
    	'cyan_toner_ink_level' => 'Cián toner/tinta',
    	'magenta_toner_ink_level' => 'Magenta toner/tinta',
    	'yellow_toner_ink_level' => 'Sárga toner/tinta',
    	'inventory_id' => 'Leltári szám',
    	'action' => 'Művelet',
    	'paper_jam_counter' => 'Papírbegyűrés/30nap',
    	'service_call_counter' => 'Szervízhívás/30nap',
    	'printed_pages_counter' => 'Nyomtatott oldalak/30nap',
    	'toner_approx_enough' => 'Körülbelül még :days napra elég :date-ig.',
    	'registered' => 'Regisztrálva',
    	'last_updated' => 'Utoljára frissítve',
    	'date_time' => 'Dátum, idő',
    	'event' => 'Esemény',
    ],

	'network_devices' => [
    	'network_devices' => 'Hálózati eszközök',
    	'network_device' => 'Hálózati eszköz',
    	'new_network_device' => 'Új hálózati eszköz',
    	'helper' => '2x kattintás a cellára a szerkesztéshez, Shift+Enter a mentéshez, Escape a kilépéshez',
    	'name' => 'Név',
    	'brand_model' => 'Márka, Típus',
    	'serial' => 'Sorozatszám',
    	'type' => 'Típus',
    	'ip_address' => 'IP cím',
    	'mac_address' => 'MAC cím',
    	'ports' => 'Portok száma',
    	'speed' => 'Sebesség',
    	'network' => 'Hálózati kapcsolat',
    	'actions' => 'Műveletek',
    
    ],

	'topology' => [
    	'topology' => 'Topológia',
    	'internet_connection' => 'Internet kapcsolat',
    	'network_device' => 'Hálózati eszköz',
    	'online' => 'Bekapcsolva',
    	'offline' => 'Kikapcsolva',
    	'unreachable' => 'Nem elérhető',
    	'network_printer' => 'Hálózati nyomtató',
    	'export_svg' => 'Exportálás (SVG)',
    	'export_gexf' => 'Exportálás (GEXF)',
    	'utp_connection' => 'UTP innen',
    	'monomode_connection' => 'Monomódus innen',
    	'multimode_connection' => 'Multimódus innen',
    	'delete_connection' => 'Törlés innen...',
    	
    ],

	'command_center' => [
    	'command_center' => 'Parancsközpont',
    	'new_command' => 'Új parancs',
    	'script_storage' => 'Szkript-tár',
    	'created' => 'Létrehozva',
    	'earliest_run_time' => 'Legkorábbi futás ideje',
    	'script' => 'Szkript',
    	'progress' => 'Feldolgozottság',
    	'details' => 'Részletek',
    	'emergency_stop' => 'Vészleállítás',
    	'no_command_found' => 'Még nincs rögzített parancs.',
    	'interrupted' => 'Megszakítva',
    	'predefined_scripts' => 'Előre definiált szkriptek',
    	'select_script' => 'Válassz egy szkriptet!',
    	'notes' => 'Megjegyzések',
    	'workstations' => 'Munkaállomások',
    	'workstation' => 'Munkaállomás',
    	'command_details' => 'Parancs részletei',
    	'no_script_selected' => 'Egy szkriptet ki kell választani.',
    	'no_date_selected' => 'Legkorábbi futás dátumát ki kell választani.',
    	'no_time_selected' => 'Legkorábbi futás idejét ki kell választani.',
    	'date_time_past' => 'A dátumnak és az időnek nagyobbnak kell lenni a jelenleginél.',
    	'success' => 'Parancs sikeresen elmentve.',
    	'no_workstation_selected' => 'Nincs kiválasztva munkaállomás',
    	'no_command_found' => 'Ez a parancs nem található.',
    	'edit_not_possible' => 'Ez a parancs már nem szerkeszthető, mert a munkaállomások megkezdték a feldolgozását.',
    	'results' => 'Eremények',
    	'result' => 'Eredmény',
    	'date_and_time' => 'Dátum/Idő',
    	'delete_script_from_database' => 'Szkript törlése adatbázisból',
    	'are_you_sure_delete_script' => 'Biztos, hogy törlöd ezt a szkriptet az adatbázisból?',
    	
    ],

	'articles' => [
    	'articles' => 'TudásBázis',
    	'no_post_found' => 'Még nincs bejegyzés.',
    	'updated' => 'Frissítve',
    	'read_more' => 'Tovább olvasom',
    	'new_post' => 'Új bejegyzés',
    	'search' => 'Keresés',
    	'publish' => 'Közzététel',
    	'categories' => 'Kategóriák',
    	'new_category' => 'Új kategória',
    	'title' => 'Cím',
    	'content' => 'Tartalom',
    	'filter' => 'Szűrés...',
    	'category_name' => 'Kategória neve',
    	'comment' => 'Hozzászólás',
    	'comments' => 'Hozzászólások',
    	'print' => 'Nyomtatás',
    	'edit' => 'Szerkesztés',
    	'send' => 'Beküldés',
    	'your_comment' => 'Hozzászólásod',
    	'tags' => 'Témakörök',
    	
    	
    ],

	'documents' => [
    	'documents' => 'Dokumentumok',
    	'new_document' => 'Új dokumentum',
    	'upload_document' => 'Dokumentum feltöltése',
    	'search' => 'Keresés',
    	'name' => 'Név',
    	'keywords' => 'Kulcsszavak',
    	'original_date' => 'Keltezés',
    	'size' => 'Méret',
    	'username' => 'Felhasználó',
    	'created' => 'Készült',
    	'actions' => 'Műveletek',
    	'archives' => 'Archívum',
    	'restore' => 'Visszaállít',
    	'select_file' => 'Fájl kiválasztása',	
    	'document_name' => 'Dokumentum neve',
    
    ],

	'operating_systems' => [
    	'operating_systems' => 'Operációs rendszerek',
    	'name' => 'Név',
    	'release_date' => 'Kiadás dátuma',
    	'end_of_support' => 'Támogatás vége',
    	'helper' => '2x kattintás a cellára a szerkesztéshez, Shift+Enter a mentéshez, Escape a kilépéshez',
    	'not_found_os' => 'Még nincs operációs rendszer kigyűjtve.',
    	'warning' => 'Figyelmezetetés!',
    	'end_of_support_needed' => 'Az operációs rendszer támogatásának végét ki kell tölteni, hogy az elavult operációs rendszerek figyelmeztetése megjelenjen.',
    	'end_of_support_reached' => 'A(z) :os_name támogasása :date dátummal lejárt!',
    
    	
    ],

	

	'user_settings' => [
    	'my_settings' => 'Beállításaim',
    	'theme' => 'Megjelenés',
    	'light' => 'Világos',
    	'dark' => 'Sötét',
    	'language' => 'Nyelv',
		'default' => 'Alapértelmezett',
    
    ],
	
	'login' => [
    	'login' => 'Bejelentkezés',
    	'email' => 'Email cím',
    	'password' => 'Jelszó',
    	'remember_me' => 'Bejelentkezés megjegyzése',
    	'forgot_password' => 'Elfelejtettem a jelszavam',
    	'registration' => 'Regisztráció',
    	'downloads' => 'Letöltések',
    	'login_failed' => 'Bejelentkezés sikertelen.',
    	'register_success' => 'Regisztráció sikeres volt. Várj amíg egy adminisztrátor engedélyezi fiókodat.',
    ],

	'register' => [
    	'registration' => 'Regisztráció',
    	'email' => 'Email cím',
    	'password' => 'Jelszó',
    	'password_again' => 'Jelszó mégegyszer',
    	'fullname' => 'Teljes név',
    	'back_to_login' => 'Vissza a bejelentkezéshez',
    ],

	'lost_password' => [
    	'lost_password' => 'Elfelejtett Jelszó',
    	'email' => 'Email cím',
    	'send_email' => 'Email küldése',
    	'back_to_login' => 'Vissza a bejelentkezéshez',
    	'reset_password' => 'Jelszó visszaállítása',
    	'password' => 'Jelszó',
    	'password_confirm' => 'Jelszó megerősítése',
    	'save' => 'Mentés',
    	'reset_success' => 'Jelszó sikeresen frissítve.',
    ],

	'downloads' => [
    	'downloads' => 'Letöltések',
    	'upload' => 'Feltöltés',
    	'download_not_found' => 'Nincs letölthető fájl.',
    	'back_to_login' => 'Vissza a bejelentkezéshez',
    	'64bit_system' => 'Ez a számítógép: 64-bites rendszer',
    	'32bit_system' => 'Ez a számítógép: 32-bites rendszer',
    	'public' => 'Nyilvános',
    	'alias' => 'Elnevezés',
    	'filename' => 'Fájlnév',
    	'size' => 'Méret',
    	'counter' => 'Számláló',
    	'created' => 'Feltöltve',
    	'actions' => 'Műveletek',
    	'upload_file' => 'Fájl feltöltése',
    	'select_file' => 'Fájl kiválasztása',
    	'are_you_sure_delete_file' => 'Biztos, hogy törölni akarod ezt a fájlt?',
    ],

	'updates' => [
    	'updates' => 'Frissítések',
    	'upload' => 'Feltöltés',
    	'channel' => 'Csatorna',
    	'version' => 'Verzió',
    	'notes' => 'Megjegyzések',
    	'created' => 'Feltöltve',
    	'counter' => 'Számláló',
    	'actions' => 'Műveletek',
    	'select_file' => 'Fájl kiválasztása',
    	'upload_file' => 'Fájl feltöltése',
    	'deploy' => 'Élesítés',
    	'delete' => 'Törlés',
    	'revoke' => 'Visszavonás',
    	'are_you_sure_delete_update' => 'Biztos, hogy törölni akarod ezt a frissítést?',
    	'are_you_sure_deploy_update' => 'Biztos, hogy élesíteni akarod ezt a frissítést?',
    	'are_you_sure_revoke_update' => 'Biztos, hogy vissza akarod vonni ezt a frissítést?',
    	
    ],


	'about' => [
    	'about' => 'Névjegy',
    	'creator' => 'Készítő',
    	'contributors' => 'Közreműködők',
    	'version' => 'Verzió',
    	'created' => 'Készült',
    	'license' => 'Licensz',
    	'thanks' => 'Köszönet:',
    	'version' => 'verzió',
    ],

	'help' => [
    	'help' => 'Súgó',
    	'helper_text' => 'Keresd a Felhasználói Útmutatót a Dokumentumok menüpontban.',
    ],

	'users' => [
    	'users' => 'Felhasználók',
    	'status' => 'Állapot',
    	'username' => 'Felhasználónév',
    	'email' => 'Email',
    	'last_login' => 'Utolsó bejelentkezés',
    	'permissions' => 'Jogosultságok',
    	'activities' => 'Tevékenységek',
    	'disable' => 'Letiltás',
    	'enable' => 'Engedélyezés',
    	'user_permissions' => ':username jogosultságai',
    	'user_activities' => ':username tevékenységei',
    	'user_activities_datetime' => 'Dátum, idő',
    	'user_activities_event' => 'Esemény',
    	'user_activities_description' => 'Leírás',
    	'user_activities_ip' => 'IP cím',
    	'user_activities_info' => 'Részletek',
    	'user_permission_read_blocks' => 'Blokkok megtekintése',
    	'user_permission_write_blocks' => 'Blokkok létrehozása',
    	'user_permission_read_eventstream' => 'Eseménynapló megtekintése',
    	'user_permission_read_interventionstream' => 'Beavatkozások megtekintése',
    	'user_permission_write_intervention' => 'Beavatkozás hozzáadása',
    	'user_permission_read_intervention_suggestions' => 'Beavatkozási javaslatok megtekintése',
    	'user_permission_read_workstations' => 'Munkaállomások megtekintése',
    	'user_permission_read_workstation' => 'Munkaállomás megtekintése',
    	'user_permission_write_workstation' => 'Munkaállomás hozzáadása/szerkesztése',
    	'user_permission_write_workstation_command' => 'Távoli parancs küldése munkaállomásnak',
    	'user_permission_delete_workstation' => 'Munkaállomás törlése',
    	'user_permission_read_subnetworks' => 'IP tábla megtekintése',
    	'user_permission_write_subnetwork' => 'Alhálózat létrehozása',
    	'user_permission_write_ips' => 'IP címek szerkesztése',
    	'user_permission_read_notifications' => 'Felügyeletek megtekintése',
    	'user_permission_write_notification' => 'Felügyelet hozzáadása/szerkesztése',
    	'user_permission_delete_notification' => 'Felügyelet törlése',
    	'user_permission_read_notifications_eventlog' => 'Felügyeleti eseménynapló megtekintése',
    	'user_permission_read_network_printers' => 'Hálózati nyomtatók megtekintése',
    	'user_permission_write_network_printer' => 'Hálózati nyomtató hozzáadása/szerkesztése',
    	'user_permission_delete_network_printer' => 'Hálózati nyomtató törlése',
    	'user_permission_read_network_devices' => 'Hálózati eszközök megtekintése',
    	'user_permission_write_network_device' => 'Hálózati eszköz hozzáadása/szerkesztése',
    	'user_permission_delete_network_device' => 'Hálózati eszköz törlése',
    	'user_permission_read_topology' => 'Topológia megtekintése',
    	'user_permission_write_topology' => 'Topológia szerkesztése',
    	'user_permission_read_batch_command' => 'Parancsközpont megtekintése',
    	'user_permission_write_batch_command' => 'Parancs hozzáadása/szerkesztése',
    	'user_permission_read_script' => 'Szkriptek megtekintése',
    	'user_permission_delete_script' => 'Szkriptek törlése',
    	'user_permission_read_articles' => 'TudásBázis megtekintése',
    	'user_permission_read_post' => 'Bejegyzés megtekintése',
    	'user_permission_write_post' => 'Bejegyzés hozzáadása/szerkesztése',
    	'user_permission_read_comment' => 'Hozzáaszolások olvasása',
    	'user_permission_write_comment' => 'Hozzászólás írása',
    	'user_permission_read_documents' => 'Dokumentumok megtekintése',
    	'user_permission_write_document' => 'Dokumentum hozzáadása/szerkesztése',
    	'user_permission_delete_document' => 'Dokumentum törlése',
    	'user_permission_read_operating_systems' => 'Operációs rendszerek megtekintése',
    	'user_permission_read_printers' => 'Nyomtatók megtekintése',
    	'user_permission_read_monitors' => 'Monitorok megtekintése',
    	'user_permission_read_global_settings' => 'Globális beállítások megtekintése',
    	'user_permission_write_global_settings' => 'Globális beállítások szerkesztése',
    	'user_permission_read_global_settings_eventlog' => 'Globális beállítások eseménynapló megtekintése',
    	'user_permission_read_users' => 'Felhasználók megtekintése',
    	'user_permission_read_user_activities' => 'Felhasználói tevékenység megtekintése',
    	'user_permission_read_user_permissions' => 'Felhasználói jogosultságok megtekintése',
    	'user_permission_write_user_permissions' => 'Felhasználói jogosultságok szerkesztése',
    	'user_permission_write_user_status' => 'Felhasználói állapot szerkesztése',
    	'user_permission_read_downloads' => 'Letöltések megtekintése',
    	'user_permission_write_downloads' => 'Letöltések szerkesztése',
    	'user_permission_upload_download' => 'Feltöltés a letöltésekbe',
    	'user_permission_delete_download' => 'Törlés a letöltésekből',
    	'user_permission_read_updates' => 'Frissítések megtekintése',
    	'user_permission_upload_update' => 'Feltöltés a frissítésekbe',
    	'user_permission_edit_updates' => 'Frissítések szerkesztése',
    	'user_permission_save_success' => 'Felhasználói jogosultságok sikeresen mentve!',
    	'user_permission_read_api_tokens' => 'API tokenek megtekintése',
    	'user_permission_write_api_tokens' => 'API tokenek létrehozása/szerkesztése',
    	'user_permission_revoke_api_tokens' => 'API tokenek visszavonása',
    	'forgot_password_email_sent_out' => 'Kiküldésre került egy email. Kattints a hivatkozásra az új jelszavad beállításához.',
    	'set_new_password_subject' => 'Új jelszó beállítása.',
    	
    ],

	'global_settings' => [
    	'notifications_off_warning' => 'A Felügyeleti eseményekről nincs értesítés! Az értesítések visszakapcsolásához engedélyezd az',
    	'option' => 'változót a',
    	'global_settings' => 'Globális Beállításokban',
    	'th_name' => 'Név',
    	'th_value' => 'Érték',
    	'th_datetime' => 'Dátum/idő',
    	'th_settings' => 'Beállítás',
    	'th_event' => 'Esemény',
    	'title_global_settings_log' => 'Globális Beállítások Eseménynapló',
    	'global_settings_not_found' => 'Még nincs globális beállítási lehetőség.',
    	'global_settings_log_not_found' => 'Még nincs globális beállításokkal kapcsolatos esemény.',
    ],

	'api_tokens' => [
    	'api_tokens' => 'API Tokenek',
    	'btn_create' => 'Új token',
    	'token_not_found' => 'Token nem található.',
    	'new_api_token' => 'Új API token készítése',
    	'name' => 'Elnevezés',
    	'token' => 'Token',
    	'max_uses' => 'Max. haszn. alkalom',
    	'max_uses_helper' => 'Opcionális. Hagyd üresen, ha korlátlan alkalommal lehet használni.',
    	'expires' => 'Lejárati dátum és idő',
    	'expires_helper' => 'Opcionális. Hagyd üresen, ha soha ne járjon le.',
    	'active' => 'Aktív',
    	'type' => 'Típus',
    	'id' => 'ID',
    	'uses' => 'Haszn./Max.',
    	'last_use' => 'Utolsó haszn.',
    	'copy' => 'Másolás vágólapra',
    	'revoke_btn' => 'Visszavonás',
    	'actions' => 'Műveletek',
    	'copied' => 'Másolva!',
    	'failed' => 'Sikertelen!',
    ],
 
	'languages' => [
    	'hu' => 'Magyar',
    	'en' => 'English',
    	'es' => 'Espanol',
    
    ],

];
