<?php

return [

    /*
    |--------------------------------------------------------------------------
    | English Language Lines
    |--------------------------------------------------------------------------
    */
	'validation' => [
    	'numeric' => 'Only numbers allowed.',
     	'required' => 'This field is required.',
    	'date' => 'A valid date is required.',
    	'ip' => 'A valid IP Address is required',
    	'required_without_all' => 'At least one of these fields is required.',
    	'regex' => 'Follow the required pattern for this field.',
    	'email' => 'A valid email address is required.',
    	'email_not_found' => 'Email address not found.',
    	'email_token_found' => 'A reset email already sent.',
    	'min_8' => 'Minimum 8 characters needed.',
    	'string' => 'Only letter, number and other characters accepted.',
    	'password_confirm' => 'Both password field must be the same.',
    	'username_unique' => "You cannot choose this name.",
    	'email_unique' => "You cannot choose this email.",
    ],


	'button' => [
    	'login' => 'Log In',
    	'save' => 'Save',
    	'send' => 'Send',
    	'cancel' => 'Cancel',
    	'back' => 'Back',
    	'back_without_save' => 'Back (Without Save)',
    	'ok' => 'OK',
    	'close' => 'Close',
    	'search' => 'Search',
    	'view' => 'View',
    	'view_notification_log' => 'View Notification Log',
    	'view_global_settings_log' => 'View Global Settings Log',
    	'view_dashboard' => 'Dashboard View',
    	'view_stored_scripts' => 'View Stored Scripts',
    	'view_details' => 'View Details',
    	'view_global_settings_event_log' => 'View Global Settings Eventlog',
    	'emergency_stop' => 'Emergency Stop',
    	'archive' => 'Archive',
    	'delete' => 'Delete',
    	'new' => 'New',
    	'new_subnetwork' => 'New Subnetwork',
    	'new_workstation' => 'New Workstation',
    	'new_network_printer' => 'New Network Printer',
    	'new_network_device' => 'New Network Device',
    	'new_command' => 'New Command',
    	'new_article' => 'New Article',
    	'new_document' => 'New Document',
    	'new_label' => 'New Label',
    	'new_intervention' => 'New Intervention',
    	'new_subnet' => 'New Subnet',
    	'new_notification' => 'New Notification',
    	'edit' => 'Edit',
    	'add' => 'Add',
    	'add_new' => 'Add New',
    	'run' => 'Run',
    	'create' => 'Create',
    	'create_new_notification' => 'Create New Notification',
    	'register' => 'Register',
    	'refresh' => 'Refresh',
    	'refresh_data' => 'Refresh Data',
    	'read_more' => 'Read More',
    	'upload' => 'Upload',
    	'download' => 'Download',
    	'collect_data' => 'Collect Data',	
		'update_data' => 'Update Data',
    	'create_filter' => 'Create Filter',
    	'yes' => 'Yes',
    	'no' => 'No',
    	'activate' => 'Activate',
    	'deactivate' => 'Deactivate',
    	'back_global_settings' => 'Back to Global Settings',
    	'global_settings_not_found' => 'There is no global setting option yet.',
    	'global_settings_log_not_found' => 'There are no global settings events yet.',
    ],
	
	'nav' => [
    	'dashboard' => 'Dashboard',
    	'workstations' => 'Workstations',
    	'ip_table' => 'IP Table',
    	'notification_center' => 'Notification Center',
    	'network_printers' => 'Network Printers',
    	'network_devices' => 'Network Devices',
    	'topology' => 'Topology',
    	'command_center' => 'Command Center',
    	'assets' => 'Assets',
    	'articles' => 'Knowledge Base',
    	'documents' => 'Documents',
    	'operating_systems' => 'Operating Systems',
    	'monitors' => 'Monitors',
    	'local_printers' => 'Local Printers',
    	'global_settings' => 'Global Settings',
    	'username' => ':username',
    	'my_settings' => 'My Settings',
    	'logout' => 'Logout',
    	'about' => 'About',
    	'help' => 'Help',
    	'users' => 'Users',
    	'downloads' => 'Downloads',
    	'updates' => 'Updates',
    	'api_tokens' => 'API Tokens',
    ],
	
	'layout' => [
		'find_workstation' => 'Find Workstation',
		'intervention' => 'Add Intervention',
		'what_happened' => 'What happened?',
		'event_description' => 'Event description...',
		'operators' => 'Operators',
		'standby_duty' => 'Standby Duty',
		'interval' => 'Time Interval',
		'start_typing' => 'Start typing...',
    	'save_this_suggestion' => 'Save this as a future suggestion',
    	'delete_this_suggestion' => 'Delete this suggestion',
    	'env_master_key_warning' => 'In the .env file, set the value of the MASTER_KEY. (MASTER_KEY=[32 characters (A-Z,a-z,0-9)].',
    ],

	'dashboard' => [
    	'dashboard' => 'Dashboard',
		'workstations' => 'Workstations',
    	'online' => 'Online',
    	'offline' => 'Offline',
    	'locked' => 'Locked',
    	'unreachable' => 'Unreachable',
    	'security_risks' => 'Security Risks',
    	'anydesk_connected' => 'Anydesk',
    	'teamviewer_connected' => 'Teamviewer',
    	'rdp_connected' => 'RDP',
    	'vnc_connected' => 'VNC',
    	'usb_connected' => 'USB dev.',
    	'ip_conflict' => 'IP conflict',
		'mac_conflict' => 'MAC conflict',
		'storages' => 'Storages',
    	'invalid_hostnames' => 'Invalid Hostname',
    	'smarterror' => 'S.M.A.R.T. error',
    	'network_printers' => 'Network printers',
    	'order_printer_supply' => 'Order Supplies',
    	'notifications' => 'Notifications',
    	'services' => 'Services',
    	'statistics' => 'Statistics',
    	'workstations_average_age' => 'Workst. avg. age',
    	'eventlog' => 'Eventlog',
    	'interventions' => 'Interventions',
    	'suggested_interventions' => 'Suggested Interventions',
    	'amount' => 'Amount',
    	'action' => 'Action',
    	'monday' => 'Monday',
		'tuesday' => 'Tuesday',
		'wednesday' => 'Wednesday',
		'thursday' => 'Thursday',
		'friday' => 'Friday',
		'saturday' => 'Saturday',
		'sunday' => 'Sunday',
      	'add_module' => 'Add Block',
    	'block_type' => 'Block Type',
    	'block_content' => 'Block Content',
    	'empty' => 'Empty',
    	'links' => 'Links',
    	'link_name' => 'Link Name',
    	'link_url' => 'Link URL',
    	'filter_cpu_score_less' => 'CPU score less than :value points',
    	'filter_cpu_score_more' => 'CPU score more than :value points',
    	'filter_boottime_more' => 'Boot Time more than :seconds second(s)',
    	'filter_uptime_more' => 'Uptime more than :days day(s)',
    	'filter_cpu_age_less' => 'CPU age less than :age year(s)',
    	'filter_cpu_age_more' => 'CPU age more than :age year(s)',
    	'filter_cpu_age_exactly' => 'CPU age exactly :age year(s) old',
    	'filter_memory_less' => 'Memory amount less than :memoryGB',
    	'filter_memory_more' => 'Memory amount more than :memoryGB',
    	'filter_memory_exactly' => 'Memory amount exactly :memoryGB',
    	'filter_os_drive_free_space_less_or_equal' => 'Free disk space on the system drive is less than or equal :spaceGB',
    	'filter_brand_contains' => 'Brand, Model contains ":value"',
    	'filter_brand_not_contains' => 'Brand, Model not contains ":value"',
    	'filter_brand_exactly' => 'Brand, Model exactly ":value"',
    	'filter_hostname_contains' => 'Hostname contains ":value"',
    	'filter_hostname_not_contains' => 'Hostname not contains ":value"',
    	'filter_hostname_exactly' => 'Hostname exactly ":value"',
    	'filter_workgroup_contains' => 'Workgroup contains ":value"',
    	'filter_workgroup_not_contains' => 'Workgroup not contains ":value"',
    	'filter_workgroup_exactly' => 'Workgroup exactly ":value"',
    	'filter_osname_contains' => 'Operating System name contains ":value"',
    	'filter_hw_types' => 'Hardware types: :types',
    	'filter_disk_types' => 'Disk types: :types',
    	'filter_serial_missing' => 'Does not have a serial number',
    	'filter_inventory_missing' => 'Does not have an inventory ID',
    	'filter_offline_more' => 'Offline more than :days day(s)',
    	'filter_osupdate_outdated' => 'Operating System not updated since :months month(s)',
    	'filter_admin_rights' => 'Users have admin rights',
    	'filter_has_any_labels' => 'Has any of these label(s): :labels',
    	'filter_has_all_labels' => 'Has all of these label(s): :labels',
    	'filter_not_has_any_labels' => 'Does not have any of these label(s): :labels',
    	'filter_not_has_all_labels' => 'Does not have all of these label(s): :labels',
    	'filter_has_ipv6' => 'Has an IPv6 address',
    	'filter_ossupport_ended' => 'Operating System support ended by the manufacturer',
    	'filter_are_you_sure_delete' => 'Are you sure you want to delete this filter?',
    	
    ],

	'workstations' => [
    	'workstation' => 'Workstation',
    	'workstations' => 'Workstations',
    	'name' => 'Name',
    	'alias' => 'Alias',
    	'hostname' => 'Hostname',
    	'workgroup' => 'Workgroup',
		'last_online' => 'Last Online',
		'os_version' => 'OS version',
		'last_os_update' => 'Last Updated',
    	'inventory_id' => 'Inventory ID',
    	'manual' => 'Manual',
    	'registered_manually' => 'Workstations registered manually',
    	'data_sheet' => 'Datasheet',
    	'connections' => 'Connections',
    	'conn_type' => 'Type',
    	'conn_value' => 'Value',
    	'conn_notes' => 'Notes',
    	'conn_action' => 'Action',
    	'phone' => 'Phone',
    	'email' => 'Email',
    	'location' => 'Location',
    	'connect' => 'Connect',
    	'call' => 'Call',
    	'send' => 'Send',
    	'navigate' => 'Navigate',
    	'save' => 'Save',
    	'cancel' => 'Cancel',
    	'add_connection' => 'Add Connection',
    	'no_information_found' => 'No available information found.',
    	'are_you_sure_delete_connection' => "Are you sure you want to delete this connection?",
    	'events' => 'Events',
    	'interventions' => 'Interventions',
    	'consol' => 'Console',
    	'suggestions' => 'Suggestions',
    	'network' => 'Network',
    	'statistics' => 'Statistics',
    	'actions' => 'Actions',
    	'brand_model' => 'Brand, Model',
    	'serial' => 'Serial Number',
    	'motherboard_serial' => 'Motherboard Serial Number',
    	'registered' => 'Registered',
    	'memory' => 'Memory',
    	'memory_slots' => 'Memory Slots',
    	'memory_max' => 'Max. Memory',
    	'memory_modules' => 'Memory Modules',
    	'other' => 'Other',
    	'monitors' => 'Monitors',
    	'disks' => 'Disks',
    	'labels' => 'Labels',
    	'local_user_accounts' => 'Local User Accounts',
    	'administrator' => 'Administrator',
    	'processor' => 'Processor',
    	'processor_released' => 'Processor released',
    	'yyyymmdd' => 'YYYY-MM-DD',
    	'operating_system' => 'Operating System',
    	'hyberboot_active' => 'Hyberboot is active!',
    	'os_activated' => 'OS activated.',
    	'os_not_activated' => 'OS not activated.',
    	'last_os_update_search' => 'Update Last Searched',
    	'last_boot_time' => 'Last Boot Time',
    	'boot_time' => 'Boot Time',
    	'service_started' => 'Service Started',
    	'os_partition_size' => 'OS Partition Size',
    	'os_partition_free_space' => 'Free Space',
    	'ip_addresses' => 'IP Addresses',
    	'dns_addresses' => 'DNS Addresses',
    	'default_mac' => 'Default MAC',
    	'manufacturer_code' => 'Manufacturer Code',
    	'manufacture_year' => 'Manufactured',
    	'printers' => 'Printers',
    	'event' => 'Event',
    	'event_time' => 'Event Time',
    	'event_description' => 'Event Description',
    	'intervention_time' => 'Intervention Time',
    	'intervention_description' => 'Intervention Description',
    	'endpoint_network_connection' => 'Endpoint Network Connection',
    	'network_data' => 'Network Data',
    	'turn_on_off_computer' => 'Turn On/Off Computer',
    	'restart_computer' => 'Restart Computer',
    	'restart_spooler' => 'Restart Printer Spooler',
    	'clear_and_restart_spooler' => 'Clear and Restart Printer Spooler',
    	'console_fun' => 'Lets begin the fun!',
    	'archive_in_progress' => 'Archiving in progress...',
    	'label_text' => 'Label text',
    	'save_script_to_storage' => 'Save Script to Storage',
    	'script_storage' => 'Script Storage',
    	'script_name' => 'Script Name',
    	'script' => 'Script',
    	'general' => 'General',
    	'are_you_sure_run' => 'Are you sure you want to run this script?',
    	'are_you_sure_delete_ip' => 'Are you sure you want to delete this ip from database?',
    	'type' => 'Device Type',
    	'desktop' => 'Desktop',
    	'laptop' => 'Laptop',
    	'server' => 'Server',
    	'identification_details' => 'Identification Details',
    	'product_serial' => 'Product Serial Number',
    	'product_serial_help' => 'The serial number located in BIOS',
	   	'motherboard_serial_help' => 'Serial number of the motherboard',
    	'first_mac_address' => 'First MAC Address',
    	'first_mac_address_help' => 'The first MAC Address of the motherboard',
    	'identification_chance' => 'Chance of Identification',
    	'start_typing' => 'Start typing...',
    	'technical_details' => 'Technical Details',
    	'network_details' => 'Network Details',
    	'ip_address' => 'IP Address',
    	'dns_address' => 'DNS Address',
    	'disk' => 'Disk',
    	'disk_type' => 'Type',
    	'disk_capacity' => 'Capacity',
    	'add_disk' => 'Add Disk',
    	'monitor' => 'Monitor',
    	'add_monitor' => 'Add Monitor',
    	'create_filter' => 'Create Filter',
    	'filter_name' => 'Filter Name',
		'filter_short_description' => 'Short Description',
		'filter_brand_model' => 'Brand, Model',
    	'filter_contains' => 'CONTAINS',
    	'filter_not_contains' => 'NOT CONTAINS',
    	'filter_exactly' => 'EXACTLY',
    	'filter_hostname' => 'Hostname',
    	'filter_workgroup' => 'Workgroup Name',
    	'filter_cpu_score' => 'CPU Score',
    	'filter_more_than' => 'MORE THAN',
    	'filter_less_than' => 'LESS THAN',
    	'filter_less_or_equal' => 'LESS THAN OR EQUAL',
    	'filter_cpu_age' => 'CPU Age',
    	'filter_years' => 'year(s)',
    	'filter_memory' => 'Memory Amount',
    	'filter_os_drive_free_space' => 'OS Drive Free Space',
    	'filter_os_name' => 'Operating System Name contains',
    	'filter_os_update' => 'Operating System updated more than',
    	'filter_months' => 'month(s)',
    	'filter_disk' => 'Type of Disk (OR relation)',
    	'filter_unspecified' => 'Unspecified',
    	'filter_hw_type' => 'Hardware Type (OR relation)',
    	'filter_desktop' => 'Desktop',
    	'filter_laptop' => 'Laptop',
    	'filter_server' => 'Server',
    	'filter_labels' => 'the following labels',
    	'filter_any_of_them' => 'ANY OF (OR)',
    	'filter_all_of_them' => 'ALL OF (AND)',
    	'filter_has_ipv6' => 'Has IPv6 address.',
    	'filter_serial_missing' => 'Does not have a serial number.',
    	'filter_inventory_missing' => 'Does not have an inventory ID.',
    	'filter_has_admin_account' => 'Users have admin rights. (Except listed in the Global Settings)',
    	'filter_support_ended' => 'The support of the Operating System ended by the manufacturer.',
    	'filter_offline_since' => 'Offline since ',
    	'filter_days' => 'day(s)',
    	'filter_boottime_more_than' => 'Boot Time more than',
    	'filter_uptime_more_than' => 'Uptime more than',
    	'filter_seconds' => 'second(s)',
    	'filter_uptime' => 'Uptime',
    	'filter_offline' => 'Offline since',
    	'filter_points' => 'points',
    	'printer_statistics' => 'Printer Stats',
    	'monthly_prints' => 'Number of Prints (30 days)',
    	'monthly_pages' => 'Number of Pages (30 days)',
    	'prints' => 'Prints',
    	'pages' => 'Pages',
    
    ],

	'subnet' => [
    	'ip_table' => 'IP Table',
    	'no_subnet_found' => 'No subnet found.',
    	'ip_address' => 'IP Address',
    	'device' => 'Device',
    	'parameters' => 'Subnet Parameters',
    	'alias' => 'Name',
    	'ip_mask' => 'Subnet IP/Decimal Mask',
    	'gateway' => 'Gateway',
    	'short_description' => 'Short Description',
    	
    
    ],

	'notification_center' => [
    	'notification_center' => 'Notification Center',
    	'eventlog' => 'Notification Eventlog',
    	'dashboard_view' => 'Dashboard View',
    	'status' => 'Status',
    	'alias' => 'Name',
    	'name' => 'Variable Name',
    	'name_helper' => 'Unique variable name sent by an outer device or system. (a-z, 0-9, -) 2-100 character',
    	'name_restriction' => 'I know what i am doing, and i want to change it.',
    	'type' => 'Type',
    	'parameters' => 'Parameters',
    	'description' => 'Description',
    	'value' => 'Value',
    	'active' => 'Active',
    	'alert' => 'Alert',
    	'idle' => 'Idle',
    	'socket_polling' => 'Socket Polling',
    	'socket_polling_description' => 'The goal is to reach the port of the given IP successfully. Otherwise triggers an alert.',
    	'sensor_value' => 'Sensor Value',
    	'sensor_value_description' => 'The given arithmetic expression or comparison in the Parameters must be true. Otherwise triggers an alert.',
    	'ping' => 'Ping',
    	'ping_description' => 'At least 50% of the ping packets must reach the given IP successfully.  Othewise triggers an alert.',
    	'mass_heartbeat_loss' => 'Mass Heartbeat Loss',
    	'mass_heartbeat_loss_description' => 'The unreachable workstations in the same 2 minutes timeframe must be less than the given number in the parameters. Otherwise triggers an alert.',
    	'biglan_command' => 'BigLan Command',
    	'biglan_command_description' => 'The given arithmetic expression or comparison in the Parameters must be true for the result of the given Command to the specific workstation identified with WSID. Otherwise triggers an alert.',
    	'snmp_description' => 'The given arithmetic expression or comparison in the Parameters must be true for the value of the given OID code queried from the given IP address. Otherwise triggers an alert.',
    	'http_status_code' => 'HTTP Status Code',
    	'http_status_code_description' => 'The given arithmetic expression or comparison in the Parameters must be true. Otherwise triggers an alert.',
    	'website' => 'Website Url',
    	'other' => 'Other',
    	'activated' => 'Activated',
    	'disabled' => 'Disabled',
    	'notification_not_found' => 'Notification not found.',
    	'notification_details' => 'Notification Details',
    	'are_you_sure_active' => 'Are you sure you want to change the Notification monitoring status?',
    	'ip_address' => 'IP Address',
    	'port' => 'Port',
    	'expression' => 'Expression',
    	'date_and_time' => 'Date and Time',
    	'notification_event_not_found' => 'Notification Event not found.',
    	'event' => 'Event',
    	'info' => 'Info',
    	'notification_status_changed' => 'Notification monitoring status changed',
    	'last_value' => 'Last Value',
    	'registered' => 'Registered',
    	'last_changed' => 'Last Changed',
    	'events' => 'Events',
    	'status_changed' => ':notification status changed to :status.',
    	'status_changed_with_value' => ':notification status changed to :status. (:value)',
    	'unit' => 'Unit',
    
    ],

	'network_printers' => [
    	'network_printers' => 'Network Printers',
    	'network_printer' => 'Network Printer',
    	'new_network_printer' => 'New Network Printer',
    	'name' => 'Name',
    	'brand_model' => 'Brand, Model',
    	'note' => 'Note',
    	'serial' => 'Serial Number',
    	'ip_address' => 'IP Address',
    	'mac_address' => 'MAC Address',
    	'toner_ink_level' => 'Toner/Ink Level',
    	'counter' => 'Counter',
    	'helper' => '2x click on cell to Edit, Shift+Enter to Save, Escape to Cancel',
    	'incompatible_toner_ink' => 'Incompatible Toner/Ink',
    	'network_printer_not_found' => 'Network Printer not found.',
    	'data_sheet' => 'Datasheet',
    	'events' => 'Events',
    	'statistics' => 'Statistics',
    	'black_toner_ink_level' => 'Blank Toner/Ink',
    	'cyan_toner_ink_level' => 'Cyan Toner/Ink',
    	'magenta_toner_ink_level' => 'Magenta Toner/Ink',
    	'yellow_toner_ink_level' => 'Yellow Toner/Ink',
    	'inventory_id' => 'Inventory ID',
    	'action' => 'Action',
    	'paper_jam_counter' => 'Paper Jam/30days',
    	'service_call_counter' => 'Service Call/30days',
    	'printed_pages_counter' => 'Printed Pages/30days',
    	'toner_approx_enough' => 'Approximatly enough for another :days days until :date.',
    	'registered' => 'Registered',
    	'last_updated' => 'Last Updated',
    	'date_time' => 'Date, Time',
    	'event' => 'Event',
    	
    ],
	
	'network_devices' => [
    	'network_devices' => 'Network Devices',
    	'network_device' => 'Network Device',
    	'new_network_device' => 'New Network Device',
    	'helper' => '2x click on cell to Edit, Shift+Enter to Save, Escape to Cancel',
    	'name' => 'Name',
    	'brand_model' => 'Brand, Model',
    	'serial' => 'Serial Number',
    	'type' => 'Type',
    	'ip_address' => 'IP Address',
    	'mac_address' => 'MAC Address',
    	'ports' => 'Num. of Ports',
    	'speed' => 'Speed',
    	'network' => 'Network',
    	'actions' => 'Actions',
    
    ],

	'topology' => [
    	'topology' => 'Topology',
    	'internet_connection' => 'Internet Connection',
    	'network_device' => 'Network Device',
    	'online' => 'Online',
    	'offline' => 'Offline',
    	'unreachable' => 'Unreachable',
    	'network_printer' => 'Network Printer',
    	'export_svg' => 'Export (SVG)',
    	'export_gexf' => 'Export (GEXF)',
    	'utp_connection' => 'UTP conn. start',
    	'monomode_connection' => 'Monomode conn. start',
    	'multimode_connection' => 'Multimode conn. start',
    	'delete_connection' => 'Delete connection...',
    	
    ],

	'command_center' => [
    	'command_center' => 'Command Center',
    	'new_command' => 'New Command',
    	'script_storage' => 'Script Storage',
    	'created' => 'Created',
    	'earliest_run_time' => 'Earliest Run Time',
    	'script' => 'Script',
    	'progress' => 'Progress',
    	'details' => 'Details',
    	'emergency_stop' => 'Emergency Stop',
    	'no_command_found' => 'No command found.',
    	'interrupted' => 'Interrupted',
    	'predefined_scripts' => 'Predefined Scripts',
    	'select_script' => 'Select a Script',
    	'notes' => 'Notes',
    	'workstations' => 'Workstations',
    	'workstation' => 'Workstation',
    	'command_details' => 'Command Details',
    	'no_script_selected' => 'Script must be selected.',
    	'no_date_selected' => 'Earliest date of run must be selected.',
    	'no_time_selected' => 'Earliest time of run must be selected.',
    	'date_time_past' => 'Date and time must be in the future.',
    	'success' => 'Command successfully saved.',
    	'no_workstation_selected' => 'At least 1 workstation must be selected.',
    	'no_command_found' => 'Command not found.',
    	'edit_not_possible' => 'Cannot change command because workstations started to process it.',
    	'results' => 'Results',
    	'result' => 'Result',
    	'date_and_time' => 'Date/Time',
    	'delete_script_from_database' => 'Delete Script from Database',
    	'are_you_sure_delete_script' => 'Are you sure you want to delete this script from database?',
    	
    ],

	'articles' => [
    	'articles' => 'Knowledge Base',
    	'no_post_found' => 'No post found.',
    	'updated' => 'Updated',
    	'read_more' => 'Read More',
    	'new_post' => 'New Post',
    	'search' => 'Search',
    	'publish' => 'Publish',
    	'categories' => 'Categories',
    	'new_category' => 'New Category',
    	'title' => 'Title',
    	'content' => 'Content',
    	'filter' => 'Filter...',
    	'category_name' => 'Category Name',
    	'comment' => 'Comment',
    	'comments' => 'Comments',
    	'print' => 'Print',
    	'edit' => 'Edit',
    	'send' => 'Send',
    	'your_comment' => 'Your Comment',
    	'tags' => 'Tags',
    	
    	
    ],

	'documents' => [
    	'documents' => 'Documents',
    	'new_document' => 'New Document',
    	'upload_document' => 'Upload Document',
    	'search' => 'Search',
    	'name' => 'Name',
    	'keywords' => 'Keywords',
    	'original_date' => 'Original Date',
    	'size' => 'Size',
    	'username' => 'Username',
    	'created' => 'Created',
    	'actions' => 'Actions',
    	'archives' => 'Archives',
    	'restore' => 'Restore',
    	'select_file' => 'Select File',	
    	'document_name' => 'Document Name',	
    		
    
    ],

	'operating_systems' => [
    	'operating_systems' => 'Operating Systems',
    	'name' => 'Name',
    	'release_date' => 'Release Date',
    	'end_of_support' => 'End of Support',
    	'helper' => '2x click on cell to Edit, Shift+Enter to Save, Escape to Cancel',
    	'not_found_os' => 'Operating System not found.',
    	'warning' => 'Warning!',
    	'end_of_support_needed' => 'The End of Support must be filled to display the warning for outdated operating systems.',
    	'end_of_support_reached' => ':os_name support ended at :date!',
    ],

	'user_settings' => [
    	'my_settings' => 'My Settings',
    	'theme' => 'Theme',
    	'light' => 'Light',
    	'dark' => 'Dark',
    	'language' => 'Language',
		'default' => 'Default',
    
    ],

	'login' => [
    	'login' => 'Log In',
    	'email' => 'Email',
    	'password' => 'Password',
    	'remember_me' => 'Remeber Me',
    	'forgot_password' => 'I forgot my password',
    	'registration' => 'Registration',
    	'downloads' => 'Downloads',
    	'login_failed' => 'Login failed.',
    	'register_success' => 'Registration was successful. Please wait for an administrator to approve your account.',
    ],

	'register' => [
    	'registration' => 'Registration',
    	'email' => 'Email',
    	'password' => 'Password',
    	'password_again' => 'Password Again',
    	'fullname' => 'Full Name',
    	'back_to_login' => 'Back to Login',
    ],

	'lost_password' => [
    	'lost_password' => 'Lost Password',
    	'email' => 'Email',
    	'send_email' => 'Send Email',
    	'back_to_login' => 'Back to Login',
    	'reset_password' => 'Reset Password',
    	'password' => 'Password',
    	'password_confirm' => 'Confirm Password',
    	'save' => 'Save',
    	'reset_success' => 'Password updated successfully.',
    ],
	
	'downloads' => [
    	'downloads' => 'Downloads',
    	'upload' => 'Upload',
    	'back_to_login' => 'Back to Login',
    	'64bit_system' => 'This computer: 64-bit system',
    	'32bit_system' => 'This computer: 32-bit system',
    	'public' => 'Public',
    	'alias' => 'Name',
    	'filename' => 'Filename',
    	'size' => 'Size',
    	'counter' => 'Counter',
    	'created' => 'Uploaded',
    	'actions' => 'Actions',
    	'upload_file' => 'Upload a File',
    	'select_file' => 'Select a File',
    	'are_you_sure_delete_file' => 'Are you sure you want to delete this file?',	
    ],

	'updates' => [
    	'updates' => 'Updates',
    	'upload' => 'Upload',
    	'channel' => 'Channel',
    	'version' => 'Version',
    	'notes' => 'Notes',
    	'created' => 'Uploaded',
    	'counter' => 'Counter',
    	'actions' => 'Actions',
    	'select_file' => 'Select File',
    	'upload_file' => 'Upload File',
    	'deploy' => 'Deploy',
    	'delete' => 'Delete',
    	'revoke' => 'Revoke',
    	'are_you_sure_delete_update' => 'Are you sure you want to delete this update?',
    	'are_you_sure_deploy_update' => 'Are you sure you want to deploy this update?',
    	'are_you_sure_revoke_update' => 'Are you sure you want to revoke this update?',
    		
    ],

	'about' => [
    	'about' => 'About',
    	'creator' => 'Creator',
    	'contributors' => 'Contributors',
    	'version' => 'Version',
    	'created' => 'Created',
    	'license' => 'License',
    	'thanks' => 'Thanks to',
    	'version' => 'version',
    ],

	'help' => [
    	'help' => 'Help',
    	'helper_text' => 'Find the User Guide in the Documents menu.',
    ],

	'users' => [
    	'users' => 'Users',
    	'status' => 'Status',
    	'username' => 'Username',
    	'email' => 'Email',
    	'last_login' => 'Last Login',
     	'permissions' => 'Permissions',
    	'activities' => 'Activities',
   		'disable' => 'Disable',
    	'enable' => 'Enable',
		'user_permissions' => 'Permissions of :username',
    	'user_activities' => 'Activities of :username',
    	'user_activities_datetime' => 'Date, Time',
    	'user_activities_event' => 'Event',
    	'user_activities_description' => 'Description',
    	'user_activities_ip' => 'IP Address',
    	'user_activities_info' => 'Details',
    	'user_permission_read_blocks' => 'View Blocks',
    	'user_permission_write_blocks' => 'Create Blocks',
    	'user_permission_read_eventstream' => 'View Eventlog',
    	'user_permission_read_interventionstream' => 'View Interventions',
    	'user_permission_write_intervention' => 'Create Intervention',
    	'user_permission_read_intervention_suggestions' => 'View Intervention Suggestions',
    	'user_permission_read_workstations' => 'View Workstations',
    	'user_permission_read_workstation' => 'View Workstation',
    	'user_permission_write_workstation' => 'Create/Edit Workstation',
    	'user_permission_write_workstation_command' => 'Send Command to Workstation',
    	'user_permission_delete_workstation' => 'Delete Workstation',
    	'user_permission_read_subnetworks' => 'View IP Table',
    	'user_permission_write_subnetwork' => 'Create Subnetwork',
    	'user_permission_write_ips' => 'Edit IP Addresses',
    	'user_permission_read_notifications' => 'View Notifications',
    	'user_permission_write_notification' => 'Create/Edit Notification',
    	'user_permission_delete_notification' => 'Delete Notification',
    	'user_permission_read_notifications_eventlog' => 'View Notification Eventlog',
    	'user_permission_read_network_printers' => 'View Network Printers',
    	'user_permission_write_network_printer' => 'Create/Edit Network Printer',
    	'user_permission_delete_network_printer' => 'Delete Network Printer',
    	'user_permission_read_network_devices' => 'View Network Device',
    	'user_permission_write_network_device' => 'Create/Edit Network Device',
    	'user_permission_delete_network_device' => 'Delete Network Device',
    	'user_permission_read_topology' => 'View Topology',
    	'user_permission_write_topology' => 'Edit Topology',
    	'user_permission_read_batch_command' => 'View Command Center',
    	'user_permission_write_batch_command' => 'Create/Edit Batch Command',
    	'user_permission_read_script' => 'View Scripts',
    	'user_permission_delete_script' => 'Delete Script',
    	'user_permission_read_articles' => 'View Knowledge Base',
    	'user_permission_read_post' => 'View Post',
    	'user_permission_write_post' => 'Create/Edit Post',
    	'user_permission_read_comment' => 'View Comments',
    	'user_permission_write_comment' => 'Create Comment',
    	'user_permission_read_documents' => 'View Documents',
    	'user_permission_write_document' => 'Create/Edit Document',
    	'user_permission_delete_document' => 'Delete Document',
    	'user_permission_read_operating_systems' => 'View Operating Systems',
    	'user_permission_read_printers' => 'View Printers',
    	'user_permission_read_monitors' => 'View Monitors',
    	'user_permission_read_global_settings' => 'View Global Settings',
    	'user_permission_write_global_settings' => 'Edit Global Settings',
    	'user_permission_read_global_settings_eventlog' => 'View Global Settings Eventlog',
    	'user_permission_read_users' => 'View Users',
    	'user_permission_read_user_activities' => 'View User Activities',
    	'user_permission_read_user_permissions' => 'View User Permissions',
    	'user_permission_write_user_permissions' => 'Edit User Permissions',
    	'user_permission_write_user_status' => 'Edit User Status',
    	'user_permission_read_downloads' => 'View Downloads',
    	'user_permission_write_downloads' => 'Edit Downloads',
    	'user_permission_upload_download' => 'Upload to Downloads',
    	'user_permission_delete_download' => 'Delete from Downloads',
    	'user_permission_read_updates' => 'View Updates',
    	'user_permission_upload_update' => 'Upload to Updates',
    	'user_permission_edit_updates' => 'Edit Updates',
    	'user_permission_save_success' => 'User permissions saved successfully!',
    	'user_permission_read_api_tokens' => 'View API Tokens',
    	'user_permission_write_api_tokens' => 'Create/Edit API Tokens',
    	'user_permission_revoke_api_tokens' => 'Revoke API Tokens',
    	'forgot_password_email_sent_out' => 'An email has been sent. Click the link to set your new password.',
    	'set_new_password_subject' => 'Set a new password.',
    
    ],

	'global_settings' => [
    	'notifications_off_warning' => 'Notifications for monitored events are turned off! To turn notifications back on, enable the ',
    	'option' => 'option in',
    	'global_settings' => 'Global Settings',
    	'th_name' => 'Name',
    	'th_value' => 'Value',
    	'th_datetime' => 'Date/Time',
    	'th_settings' => 'Settings',
    	'th_event' => 'Event',
    	'title_global_settings_log' => 'Global Settings Event Log',
    	'global_settings_not_found' => 'There are no Global Settings yet.',
    	'global_settings_log_not_found' => 'There are no global settings events yet.',
    ],

	'api_tokens' => [
    	'api_tokens' => 'API Tokens',
    	'btn_create' => 'Create New Token',
    	'token_not_found' => 'No token found.',
    	'new_api_token' => 'Create New API Token',
    	'name' => 'Name',
    	'token' => 'Token',
    	'max_uses' => 'Max. Num. of Uses',
    	'max_uses_helper' => 'Optional. Leave blank for unlimited uses.',
    	'expires' => 'Expiration Date and Time',
    	'expires_helper' => 'Optional. Leave blank if it should never expire.',
    	'active' => 'Active',
    	'type' => 'Type',
    	'id' => 'ID',
    	'uses' => 'Used/Max.',
    	'last_use' => 'Last Used',
    	'copy' => 'Copy to Clipboard',
    	'revoke_btn' => 'Revoke',
    	'actions' => 'Actions',
    	'copied' => 'Copied!',
    	'failed' => 'Failed!',
    ],

	'languages' => [
    	'hu' => 'Magyar',
    	'en' => 'English',
    	'es' => 'Espanol',
    
    ],

];
