<?php
return [
	'intervention_templates' => [
		['message' => 'Set up a new printer.'],
		['message' => 'Set up a used printer.'],
		['message' => 'Printer repair.'],
		['message' => 'Printer maintenance.'],
		['message' => 'Printer replacement.'],
		['message' => 'Set up a new monitor.'],
		['message' => 'Set up a used monitor.'],
		['message' => 'Monitor repair.'],
		['message' => 'Monitor maintenance.'],
		['message' => 'Monitor replacement.'],
		['message' => 'Set up a new computer.'],
		['message' => 'Set up a used computer.'],
		['message' => 'Computer repair.'],
		['message' => 'Computer maintenance.'],
		['message' => 'Computer replacement.'],
		['message' => 'Keyboard/mouse repair.'],
		['message' => 'Keyboard/mouse maintenance.'],
		['message' => 'Keyboard/mouse replacement.'],
		['message' => 'Software installation.'],
		['message' => 'Software repair.'],
		['message' => 'Software maintenance.'],
		['message' => 'Network repair.'],
		['message' => 'Network device installation.'],
		['message' => 'Network device replacement.'],
		['message' => 'Network setup.'],
		['message' => 'Data backup.'],
		['message' => 'Data recovery.'],
		['message' => 'Other peripheral installation.'],
		['message' => 'Other peripheral repair.'],
		['message' => 'Other peripheral replacement.'],
		['message' => 'Setting permissions.'],
		['message' => 'Modifying permissions.'],
	],
	'console_scripts' => [
        ['user_id' => 1, 'alias' => 'Communication test', 'code' => 'hello'],
        ['user_id' => 1, 'alias' => 'Network configuration', 'code' => 'ipconfig /all'],
        ['user_id' => 1, 'alias' => 'Restart BigLanService on workstation', 'code' => 'Restart-Service -Name "BigLanService"'],
        ['user_id' => 1, 'alias' => 'Clean and restart spooler', 'code' => 'Clear-Spooler'],
        ['user_id' => 1, 'alias' => 'List of all installed software', 'code' => 'Get-WmiObject -Class Win32_Product | Format-Table -Property Name, Version, InstallDate, Vendor | Out-String'],
        ['user_id' => 1, 'alias' => 'Date and time forced synchronisation on workstation', 'code' => 'net start w32time; W32tm /resync /force'],
        ['user_id' => 1, 'alias' => 'List of documents in spooler', 'code' => 'Get-WmiObject -Class Win32_PrintJob | Format-Table -Property TimeSubmitted, Name, JobId, StatusMask, TotalPages | Out-String'],
        ['user_id' => 1, 'alias' => 'List of network connections', 'code' => 'netsh interface ipv4 show interfaces'],
    ],
	'ws_filters' => [
        ['hash' => '70efdf2ec9b086079795c442636b55fb', 'name' => 'Missing Inventory ID', 'parameters' => '{"inventory":"no-inventory"}'],
        ['hash' => '9a1158154dfa42caddbd0694a4e9bdc8', 'name' => 'Not enough free space on OS drive', 'description' => 'The operating system may slow down due to the system drive being full.', 'parameters' => '{"os_drive_free_space":"10"}'],
        ['hash' => '3c59dc048e8850243be8079a5c74d079', 'name' => 'Operating system update is out of date', 'parameters' => '{"type":["desktop","laptop"],"osupdate_value":"1"}'],
    ],
	'notifications' => [
        ['type' => 'mass-heartbeat-loss', 'name' => 'mass-heartbeat-loss', 'Alias' => 'Mass Heartbeat Loss', 'description' => 'It monitors whether the computers that are turned on are logging in every minute.', 'channel' => 'telegram', 'target' => '4', 'monitored' => 1],
    ],
	'global_settings' => [
        ['name' => 'telegram-bot-token', 'type' => 'string', 'value' => '', 'description' => 'The token for the Telegram bot to which your monitoring notifications will be sent. If you don\'t have one yet, you will need to create one.'],
        ['name' => 'telegram-chat-id', 'type' => 'string', 'value' => '', 'description' => 'The Telegram chat id to which notifications are sent.'],
        ['name' => 'enable-notifications', 'type' => 'boolean', 'value' => '1', 'description' => 'Should an alarm be triggered in the event of events recorded in the Notification Center?'],
        ['name' => 'snmp-read-community', 'type' => 'string', 'value' => 'public', 'description' => 'The read community value of network printers, which can be used to query SNMP values.'],
        ['name' => 'exclude-admin-username-list', 'type' => 'string', 'value' => '', 'description' => 'List of known administrator account names.'],
        ['name' => 'network-printer-supply-order-link', 'type' => 'string', 'value' => '', 'description' => 'When you enter the URL, a link will appear on the Dashboard in the Network Printers panel, which will take you directly to the printer accessory partner\'s website.'],
        ['name' => 'enable-registration', 'type' => 'boolean', 'value' => '1', 'description' => 'Allow registration for this page.'],
    
    ],
	'downloads' => [
        ['alias' => 'BigLanService Installer 2.1.17.0', 'filename' => 'biglanservice-installer-2-1-17-0.msi', 'size' => 3451, 'published' => 1, 'counter' => 0 ],
    ],
	'documents' => [
    	['title' => 'EN BigLanService 2.1.17.0 Installation Guide', 'keywords' => 'biglan, service, installer, guide', 'source' => 'upload', 'filename' => 'EN-biglanservice-2-1-17-0-installation-guide.pdf', 'filesize' => 263837, 'user_id' => 0],
    	['title' => 'HU BigLanService 2.1.17.0 Telepítési Útmutató', 'keywords' => 'biglan, service, telepítő, útmutató', 'source' => 'upload', 'filename' => 'HU-biglanservice-2-1-17-0-telepitesi-utmutato.pdf', 'filesize' => 292355, 'user_id' => 0],
    	['title' => 'EN BigLan User Guide', 'keywords' => 'biglan, user, guide', 'source' => 'upload', 'filename' => 'EN-biglan-user-guide-20250907.pdf', 'filesize' => 508600, 'user_id' => 0],
    	['title' => 'HU BigLan Felhasználói Útmutató', 'keywords' => 'biglan, felhasználói, útmutató', 'source' => 'upload', 'filename' => 'HU-biglan-felhasznaloi-utmutato-20250907.pdf', 'filesize' => 427527, 'user_id' => 0],
    ],
	'service_updates' => [
		['channel' => 'b', 'version' => '2.1.17.0', 'description' => 'First public release.', 'filename' => 'BigLanService-beta.exe', 'active' => 1, 'counter' => 0],
		['channel' => 'a', 'version' => '2.1.17.0', 'description' => 'First public release.', 'filename' => 'BigLanService-alpha.exe', 'active' => 1, 'counter' => 0],
	],
];