<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('service_updates', function (Blueprint $table) {
            $table->id();
        	$table->string('channel', 255);
        	$table->string('version', 255);
        	$table->text('description');
            $table->string('filename', 255);
        	$table->integer('active')->default(0);
        	$table->integer('counter')->default(0);
        	$table->timestamps();
        });
        
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('service_updates');
        
    }
};
